/************************************************************************/
/*                                                                      */
/* Borland Enterprise Core Objects                                      */
/*                                                                      */
/* Copyright (c) 2003-2005 Borland Software Corporation                 */
/*                                                                      */
/************************************************************************/

using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using Borland.Eco.Handles;
using Borland.Eco.Windows.Forms;
using Borland.Eco.WinForm;
using Borland.Eco.ObjectRepresentation;
using Borland.Eco.UmlRt;
using Borland.Eco.Services;
using Borland.Eco.AutoContainers;
using Borland.Eco.Subscription;

namespace Borland.Eco.Diagnostics
{
	/// <summary>
	/// This class form part of the EcoSpace debugger.
	/// It is not intended to be used directly.
	/// </summary>
	public class DirtyObjectsDebuggerPanel: System.Windows.Forms.Form, IEcoSpaceDebuggerPanel
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.IContainer components = null;
		private System.Windows.Forms.Panel panel1;
		private Borland.Eco.Handles.ReferenceHandle rhRoot;
		private Borland.Eco.WinForm.EcoActionExtender EcoGlobalActions;
		private Borland.Eco.WinForm.EcoDragDropExtender EcoDragDrop;
		private Borland.Eco.WinForm.EcoAutoFormExtender EcoAutoForms;
		private Borland.Eco.WinForm.EcoListActionExtender EcoListActions;
		private System.Windows.Forms.DataGrid dgDirtyObjects;
		private System.Windows.Forms.MainMenu mainMenu1;
		private System.Windows.Forms.Button btnUpdate;
		private System.Windows.Forms.ListBox lbSelectedObjects;
		private Borland.Eco.Handles.ReferenceHandle rhSelectedObjects;
		private System.Windows.Forms.Button btnSelect;
		private System.Windows.Forms.Button btnUnselect;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Button btnEnclosure;
		private System.Windows.Forms.Button btnPurge;
		private System.Windows.Forms.Button btnSelectAll;
		private System.Windows.Forms.Button btnUnselectAll;

		public DirtyObjectsDebuggerPanel()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();
		}
		#region Services
		public IPersistenceService PersistenceService
		{
			get { return (IPersistenceService)EcoSpace.GetEcoService(typeof(IPersistenceService)); }
		}
		public IDirtyListService DirtyListService
		{
			get { return (IDirtyListService)EcoSpace.GetEcoService(typeof(IDirtyListService)); }
		}

		public IUndoService UndoService
		{
			get { return (IUndoService)EcoSpace.GetEcoService(typeof(IUndoService)); }
		}

		public ITypeSystemService TypeSystemService
		{
			get { return (ITypeSystemService)EcoSpace.GetEcoService(typeof(ITypeSystemService)); }
		}
		public IOclService OclService
		{
			get { return (IOclService)EcoSpace.GetEcoService(typeof(IOclService)); }
		}
		public IObjectFactoryService ObjectFactoryService
		{
			get { return (IObjectFactoryService)EcoSpace.GetEcoService(typeof(IObjectFactoryService)); }
		}
		public IVariableFactoryService VariableFactoryService
		{
			get { return (IVariableFactoryService)EcoSpace.GetEcoService(typeof(IVariableFactoryService)); }
		}
		public IExtentService ExtentService
		{
			get { return (IExtentService)EcoSpace.GetEcoService(typeof(IExtentService)); }
		}
		#endregion

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose (bool disposing)
		{
			try
			{
				if (disposing)
				{
					if (components != null)
						components.Dispose();
				}
			}
			finally
			{
				base.Dispose(disposing);
			}
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DirtyObjectsDebuggerPanel));
			this.panel1 = new System.Windows.Forms.Panel();
			this.btnUnselectAll = new System.Windows.Forms.Button();
			this.btnSelectAll = new System.Windows.Forms.Button();
			this.btnPurge = new System.Windows.Forms.Button();
			this.btnEnclosure = new System.Windows.Forms.Button();
			this.label1 = new System.Windows.Forms.Label();
			this.btnUnselect = new System.Windows.Forms.Button();
			this.btnSelect = new System.Windows.Forms.Button();
			this.lbSelectedObjects = new System.Windows.Forms.ListBox();
			this.btnUpdate = new System.Windows.Forms.Button();
			this.dgDirtyObjects = new System.Windows.Forms.DataGrid();
			this.rhSelectedObjects = new Borland.Eco.Handles.ReferenceHandle();
			this.rhRoot = new Borland.Eco.Handles.ReferenceHandle();
			this.EcoAutoForms = new Borland.Eco.WinForm.EcoAutoFormExtender();
			this.EcoDragDrop = new Borland.Eco.WinForm.EcoDragDropExtender();
			this.EcoGlobalActions = new Borland.Eco.WinForm.EcoActionExtender();
			this.EcoListActions = new Borland.Eco.WinForm.EcoListActionExtender();
			this.mainMenu1 = new System.Windows.Forms.MainMenu();
			this.panel1.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.dgDirtyObjects)).BeginInit();
			this.SuspendLayout();
			//
			// panel1
			//
			this.panel1.AccessibleDescription = resources.GetString("panel1.AccessibleDescription");
			this.panel1.AccessibleName = resources.GetString("panel1.AccessibleName");
			this.panel1.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("panel1.Anchor")));
			this.panel1.AutoScroll = ((bool)(resources.GetObject("panel1.AutoScroll")));
			this.panel1.AutoScrollMargin = ((System.Drawing.Size)(resources.GetObject("panel1.AutoScrollMargin")));
			this.panel1.AutoScrollMinSize = ((System.Drawing.Size)(resources.GetObject("panel1.AutoScrollMinSize")));
			this.panel1.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("panel1.BackgroundImage")));
			this.panel1.Controls.Add(this.btnUnselectAll);
			this.panel1.Controls.Add(this.btnSelectAll);
			this.panel1.Controls.Add(this.btnPurge);
			this.panel1.Controls.Add(this.btnEnclosure);
			this.panel1.Controls.Add(this.label1);
			this.panel1.Controls.Add(this.btnUnselect);
			this.panel1.Controls.Add(this.btnSelect);
			this.panel1.Controls.Add(this.lbSelectedObjects);
			this.panel1.Controls.Add(this.btnUpdate);
			this.panel1.Controls.Add(this.dgDirtyObjects);
			this.panel1.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("panel1.Dock")));
			this.panel1.Enabled = ((bool)(resources.GetObject("panel1.Enabled")));
			this.panel1.Font = ((System.Drawing.Font)(resources.GetObject("panel1.Font")));
			this.panel1.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("panel1.ImeMode")));
			this.panel1.Location = ((System.Drawing.Point)(resources.GetObject("panel1.Location")));
			this.panel1.Name = "panel1";
			this.panel1.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("panel1.RightToLeft")));
			this.panel1.Size = ((System.Drawing.Size)(resources.GetObject("panel1.Size")));
			this.panel1.TabIndex = ((int)(resources.GetObject("panel1.TabIndex")));
			this.panel1.Text = resources.GetString("panel1.Text");
			this.panel1.Visible = ((bool)(resources.GetObject("panel1.Visible")));
			//
			// btnUnselectAll
			//
			this.btnUnselectAll.AccessibleDescription = resources.GetString("btnUnselectAll.AccessibleDescription");
			this.btnUnselectAll.AccessibleName = resources.GetString("btnUnselectAll.AccessibleName");
			this.EcoListActions.SetActionExpression(this.btnUnselectAll, "");
			this.btnUnselectAll.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("btnUnselectAll.Anchor")));
			this.btnUnselectAll.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("btnUnselectAll.BackgroundImage")));
			this.btnUnselectAll.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("btnUnselectAll.Dock")));
			this.btnUnselectAll.Enabled = ((bool)(resources.GetObject("btnUnselectAll.Enabled")));
			this.btnUnselectAll.FlatStyle = ((System.Windows.Forms.FlatStyle)(resources.GetObject("btnUnselectAll.FlatStyle")));
			this.btnUnselectAll.Font = ((System.Drawing.Font)(resources.GetObject("btnUnselectAll.Font")));
			this.btnUnselectAll.Image = ((System.Drawing.Image)(resources.GetObject("btnUnselectAll.Image")));
			this.btnUnselectAll.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnUnselectAll.ImageAlign")));
			this.btnUnselectAll.ImageIndex = ((int)(resources.GetObject("btnUnselectAll.ImageIndex")));
			this.btnUnselectAll.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("btnUnselectAll.ImeMode")));
			this.btnUnselectAll.Location = ((System.Drawing.Point)(resources.GetObject("btnUnselectAll.Location")));
			this.btnUnselectAll.Name = "btnUnselectAll";
			this.btnUnselectAll.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("btnUnselectAll.RightToLeft")));
			this.btnUnselectAll.Size = ((System.Drawing.Size)(resources.GetObject("btnUnselectAll.Size")));
			this.btnUnselectAll.TabIndex = ((int)(resources.GetObject("btnUnselectAll.TabIndex")));
			this.btnUnselectAll.Text = resources.GetString("btnUnselectAll.Text");
			this.btnUnselectAll.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnUnselectAll.TextAlign")));
			this.btnUnselectAll.Visible = ((bool)(resources.GetObject("btnUnselectAll.Visible")));
			this.btnUnselectAll.Click += new System.EventHandler(this.btnUnselectAll_Click);
			//
			// btnSelectAll
			//
			this.btnSelectAll.AccessibleDescription = resources.GetString("btnSelectAll.AccessibleDescription");
			this.btnSelectAll.AccessibleName = resources.GetString("btnSelectAll.AccessibleName");
			this.EcoListActions.SetActionExpression(this.btnSelectAll, "");
			this.btnSelectAll.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("btnSelectAll.Anchor")));
			this.btnSelectAll.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("btnSelectAll.BackgroundImage")));
			this.btnSelectAll.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("btnSelectAll.Dock")));
			this.btnSelectAll.Enabled = ((bool)(resources.GetObject("btnSelectAll.Enabled")));
			this.btnSelectAll.FlatStyle = ((System.Windows.Forms.FlatStyle)(resources.GetObject("btnSelectAll.FlatStyle")));
			this.btnSelectAll.Font = ((System.Drawing.Font)(resources.GetObject("btnSelectAll.Font")));
			this.btnSelectAll.Image = ((System.Drawing.Image)(resources.GetObject("btnSelectAll.Image")));
			this.btnSelectAll.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnSelectAll.ImageAlign")));
			this.btnSelectAll.ImageIndex = ((int)(resources.GetObject("btnSelectAll.ImageIndex")));
			this.btnSelectAll.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("btnSelectAll.ImeMode")));
			this.btnSelectAll.Location = ((System.Drawing.Point)(resources.GetObject("btnSelectAll.Location")));
			this.btnSelectAll.Name = "btnSelectAll";
			this.btnSelectAll.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("btnSelectAll.RightToLeft")));
			this.btnSelectAll.Size = ((System.Drawing.Size)(resources.GetObject("btnSelectAll.Size")));
			this.btnSelectAll.TabIndex = ((int)(resources.GetObject("btnSelectAll.TabIndex")));
			this.btnSelectAll.Text = resources.GetString("btnSelectAll.Text");
			this.btnSelectAll.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnSelectAll.TextAlign")));
			this.btnSelectAll.Visible = ((bool)(resources.GetObject("btnSelectAll.Visible")));
			this.btnSelectAll.Click += new System.EventHandler(this.button1_Click);
			//
			// btnPurge
			//
			this.btnPurge.AccessibleDescription = resources.GetString("btnPurge.AccessibleDescription");
			this.btnPurge.AccessibleName = resources.GetString("btnPurge.AccessibleName");
			this.EcoListActions.SetActionExpression(this.btnPurge, "");
			this.btnPurge.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("btnPurge.Anchor")));
			this.btnPurge.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("btnPurge.BackgroundImage")));
			this.btnPurge.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("btnPurge.Dock")));
			this.btnPurge.Enabled = ((bool)(resources.GetObject("btnPurge.Enabled")));
			this.btnPurge.FlatStyle = ((System.Windows.Forms.FlatStyle)(resources.GetObject("btnPurge.FlatStyle")));
			this.btnPurge.Font = ((System.Drawing.Font)(resources.GetObject("btnPurge.Font")));
			this.btnPurge.Image = ((System.Drawing.Image)(resources.GetObject("btnPurge.Image")));
			this.btnPurge.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnPurge.ImageAlign")));
			this.btnPurge.ImageIndex = ((int)(resources.GetObject("btnPurge.ImageIndex")));
			this.btnPurge.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("btnPurge.ImeMode")));
			this.btnPurge.Location = ((System.Drawing.Point)(resources.GetObject("btnPurge.Location")));
			this.btnPurge.Name = "btnPurge";
			this.btnPurge.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("btnPurge.RightToLeft")));
			this.btnPurge.Size = ((System.Drawing.Size)(resources.GetObject("btnPurge.Size")));
			this.btnPurge.TabIndex = ((int)(resources.GetObject("btnPurge.TabIndex")));
			this.btnPurge.Text = resources.GetString("btnPurge.Text");
			this.btnPurge.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnPurge.TextAlign")));
			this.btnPurge.Visible = ((bool)(resources.GetObject("btnPurge.Visible")));
			this.btnPurge.Click += new System.EventHandler(this.btnPurge_Click);
			//
			// btnEnclosure
			//
			this.btnEnclosure.AccessibleDescription = resources.GetString("btnEnclosure.AccessibleDescription");
			this.btnEnclosure.AccessibleName = resources.GetString("btnEnclosure.AccessibleName");
			this.EcoListActions.SetActionExpression(this.btnEnclosure, "");
			this.btnEnclosure.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("btnEnclosure.Anchor")));
			this.btnEnclosure.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("btnEnclosure.BackgroundImage")));
			this.btnEnclosure.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("btnEnclosure.Dock")));
			this.btnEnclosure.Enabled = ((bool)(resources.GetObject("btnEnclosure.Enabled")));
			this.btnEnclosure.FlatStyle = ((System.Windows.Forms.FlatStyle)(resources.GetObject("btnEnclosure.FlatStyle")));
			this.btnEnclosure.Font = ((System.Drawing.Font)(resources.GetObject("btnEnclosure.Font")));
			this.btnEnclosure.Image = ((System.Drawing.Image)(resources.GetObject("btnEnclosure.Image")));
			this.btnEnclosure.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnEnclosure.ImageAlign")));
			this.btnEnclosure.ImageIndex = ((int)(resources.GetObject("btnEnclosure.ImageIndex")));
			this.btnEnclosure.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("btnEnclosure.ImeMode")));
			this.btnEnclosure.Location = ((System.Drawing.Point)(resources.GetObject("btnEnclosure.Location")));
			this.btnEnclosure.Name = "btnEnclosure";
			this.btnEnclosure.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("btnEnclosure.RightToLeft")));
			this.btnEnclosure.Size = ((System.Drawing.Size)(resources.GetObject("btnEnclosure.Size")));
			this.btnEnclosure.TabIndex = ((int)(resources.GetObject("btnEnclosure.TabIndex")));
			this.btnEnclosure.Text = resources.GetString("btnEnclosure.Text");
			this.btnEnclosure.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnEnclosure.TextAlign")));
			this.btnEnclosure.Visible = ((bool)(resources.GetObject("btnEnclosure.Visible")));
			this.btnEnclosure.Click += new System.EventHandler(this.btnEnclosure_Click);
			//
			// label1
			//
			this.label1.AccessibleDescription = resources.GetString("label1.AccessibleDescription");
			this.label1.AccessibleName = resources.GetString("label1.AccessibleName");
			this.label1.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("label1.Anchor")));
			this.label1.AutoSize = ((bool)(resources.GetObject("label1.AutoSize")));
			this.label1.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("label1.Dock")));
			this.label1.Enabled = ((bool)(resources.GetObject("label1.Enabled")));
			this.label1.Font = ((System.Drawing.Font)(resources.GetObject("label1.Font")));
			this.label1.Image = ((System.Drawing.Image)(resources.GetObject("label1.Image")));
			this.label1.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("label1.ImageAlign")));
			this.label1.ImageIndex = ((int)(resources.GetObject("label1.ImageIndex")));
			this.label1.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("label1.ImeMode")));
			this.label1.Location = ((System.Drawing.Point)(resources.GetObject("label1.Location")));
			this.label1.Name = "label1";
			this.label1.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("label1.RightToLeft")));
			this.label1.Size = ((System.Drawing.Size)(resources.GetObject("label1.Size")));
			this.label1.TabIndex = ((int)(resources.GetObject("label1.TabIndex")));
			this.label1.Text = resources.GetString("label1.Text");
			this.label1.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("label1.TextAlign")));
			this.label1.Visible = ((bool)(resources.GetObject("label1.Visible")));
			//
			// btnUnselect
			//
			this.btnUnselect.AccessibleDescription = resources.GetString("btnUnselect.AccessibleDescription");
			this.btnUnselect.AccessibleName = resources.GetString("btnUnselect.AccessibleName");
			this.EcoListActions.SetActionExpression(this.btnUnselect, "");
			this.btnUnselect.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("btnUnselect.Anchor")));
			this.btnUnselect.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("btnUnselect.BackgroundImage")));
			this.btnUnselect.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("btnUnselect.Dock")));
			this.btnUnselect.Enabled = ((bool)(resources.GetObject("btnUnselect.Enabled")));
			this.btnUnselect.FlatStyle = ((System.Windows.Forms.FlatStyle)(resources.GetObject("btnUnselect.FlatStyle")));
			this.btnUnselect.Font = ((System.Drawing.Font)(resources.GetObject("btnUnselect.Font")));
			this.btnUnselect.Image = ((System.Drawing.Image)(resources.GetObject("btnUnselect.Image")));
			this.btnUnselect.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnUnselect.ImageAlign")));
			this.btnUnselect.ImageIndex = ((int)(resources.GetObject("btnUnselect.ImageIndex")));
			this.btnUnselect.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("btnUnselect.ImeMode")));
			this.btnUnselect.Location = ((System.Drawing.Point)(resources.GetObject("btnUnselect.Location")));
			this.btnUnselect.Name = "btnUnselect";
			this.btnUnselect.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("btnUnselect.RightToLeft")));
			this.btnUnselect.Size = ((System.Drawing.Size)(resources.GetObject("btnUnselect.Size")));
			this.btnUnselect.TabIndex = ((int)(resources.GetObject("btnUnselect.TabIndex")));
			this.btnUnselect.Text = resources.GetString("btnUnselect.Text");
			this.btnUnselect.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnUnselect.TextAlign")));
			this.btnUnselect.Visible = ((bool)(resources.GetObject("btnUnselect.Visible")));
			this.btnUnselect.Click += new System.EventHandler(this.btnUnselect_Click);
			//
			// btnSelect
			//
			this.btnSelect.AccessibleDescription = resources.GetString("btnSelect.AccessibleDescription");
			this.btnSelect.AccessibleName = resources.GetString("btnSelect.AccessibleName");
			this.EcoListActions.SetActionExpression(this.btnSelect, "");
			this.btnSelect.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("btnSelect.Anchor")));
			this.btnSelect.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("btnSelect.BackgroundImage")));
			this.btnSelect.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("btnSelect.Dock")));
			this.btnSelect.Enabled = ((bool)(resources.GetObject("btnSelect.Enabled")));
			this.btnSelect.FlatStyle = ((System.Windows.Forms.FlatStyle)(resources.GetObject("btnSelect.FlatStyle")));
			this.btnSelect.Font = ((System.Drawing.Font)(resources.GetObject("btnSelect.Font")));
			this.btnSelect.Image = ((System.Drawing.Image)(resources.GetObject("btnSelect.Image")));
			this.btnSelect.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnSelect.ImageAlign")));
			this.btnSelect.ImageIndex = ((int)(resources.GetObject("btnSelect.ImageIndex")));
			this.btnSelect.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("btnSelect.ImeMode")));
			this.btnSelect.Location = ((System.Drawing.Point)(resources.GetObject("btnSelect.Location")));
			this.btnSelect.Name = "btnSelect";
			this.btnSelect.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("btnSelect.RightToLeft")));
			this.btnSelect.Size = ((System.Drawing.Size)(resources.GetObject("btnSelect.Size")));
			this.btnSelect.TabIndex = ((int)(resources.GetObject("btnSelect.TabIndex")));
			this.btnSelect.Text = resources.GetString("btnSelect.Text");
			this.btnSelect.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnSelect.TextAlign")));
			this.btnSelect.Visible = ((bool)(resources.GetObject("btnSelect.Visible")));
			this.btnSelect.Click += new System.EventHandler(this.btnSelect_Click);
			//
			// lbSelectedObjects
			//
			this.lbSelectedObjects.AccessibleDescription = resources.GetString("lbSelectedObjects.AccessibleDescription");
			this.lbSelectedObjects.AccessibleName = resources.GetString("lbSelectedObjects.AccessibleName");
			this.lbSelectedObjects.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("lbSelectedObjects.Anchor")));
			this.lbSelectedObjects.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("lbSelectedObjects.BackgroundImage")));
			this.lbSelectedObjects.ColumnWidth = ((int)(resources.GetObject("lbSelectedObjects.ColumnWidth")));
			this.lbSelectedObjects.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("lbSelectedObjects.Dock")));
			this.EcoAutoForms.SetEcoAutoForm(this.lbSelectedObjects, true);
			this.EcoDragDrop.SetEcoDragSource(this.lbSelectedObjects, true);
			this.EcoDragDrop.SetEcoDropTarget(this.lbSelectedObjects, true);
			this.lbSelectedObjects.Enabled = ((bool)(resources.GetObject("lbSelectedObjects.Enabled")));
			this.lbSelectedObjects.Font = ((System.Drawing.Font)(resources.GetObject("lbSelectedObjects.Font")));
			this.lbSelectedObjects.HorizontalExtent = ((int)(resources.GetObject("lbSelectedObjects.HorizontalExtent")));
			this.lbSelectedObjects.HorizontalScrollbar = ((bool)(resources.GetObject("lbSelectedObjects.HorizontalScrollbar")));
			this.lbSelectedObjects.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("lbSelectedObjects.ImeMode")));
			this.lbSelectedObjects.IntegralHeight = ((bool)(resources.GetObject("lbSelectedObjects.IntegralHeight")));
			this.lbSelectedObjects.ItemHeight = ((int)(resources.GetObject("lbSelectedObjects.ItemHeight")));
			this.lbSelectedObjects.Location = ((System.Drawing.Point)(resources.GetObject("lbSelectedObjects.Location")));
			this.lbSelectedObjects.Name = "lbSelectedObjects";
			this.lbSelectedObjects.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("lbSelectedObjects.RightToLeft")));
			this.lbSelectedObjects.ScrollAlwaysVisible = ((bool)(resources.GetObject("lbSelectedObjects.ScrollAlwaysVisible")));
			this.lbSelectedObjects.Size = ((System.Drawing.Size)(resources.GetObject("lbSelectedObjects.Size")));
			this.lbSelectedObjects.TabIndex = ((int)(resources.GetObject("lbSelectedObjects.TabIndex")));
			this.lbSelectedObjects.Visible = ((bool)(resources.GetObject("lbSelectedObjects.Visible")));
			//
			// btnUpdate
			//
			this.btnUpdate.AccessibleDescription = resources.GetString("btnUpdate.AccessibleDescription");
			this.btnUpdate.AccessibleName = resources.GetString("btnUpdate.AccessibleName");
			this.EcoListActions.SetActionExpression(this.btnUpdate, "");
			this.btnUpdate.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("btnUpdate.Anchor")));
			this.btnUpdate.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("btnUpdate.BackgroundImage")));
			this.btnUpdate.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("btnUpdate.Dock")));
			this.btnUpdate.Enabled = ((bool)(resources.GetObject("btnUpdate.Enabled")));
			this.btnUpdate.FlatStyle = ((System.Windows.Forms.FlatStyle)(resources.GetObject("btnUpdate.FlatStyle")));
			this.btnUpdate.Font = ((System.Drawing.Font)(resources.GetObject("btnUpdate.Font")));
			this.btnUpdate.Image = ((System.Drawing.Image)(resources.GetObject("btnUpdate.Image")));
			this.btnUpdate.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnUpdate.ImageAlign")));
			this.btnUpdate.ImageIndex = ((int)(resources.GetObject("btnUpdate.ImageIndex")));
			this.btnUpdate.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("btnUpdate.ImeMode")));
			this.btnUpdate.Location = ((System.Drawing.Point)(resources.GetObject("btnUpdate.Location")));
			this.btnUpdate.Name = "btnUpdate";
			this.btnUpdate.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("btnUpdate.RightToLeft")));
			this.btnUpdate.Size = ((System.Drawing.Size)(resources.GetObject("btnUpdate.Size")));
			this.btnUpdate.TabIndex = ((int)(resources.GetObject("btnUpdate.TabIndex")));
			this.btnUpdate.Text = resources.GetString("btnUpdate.Text");
			this.btnUpdate.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnUpdate.TextAlign")));
			this.btnUpdate.Visible = ((bool)(resources.GetObject("btnUpdate.Visible")));
			this.btnUpdate.Click += new System.EventHandler(this.btnUpdate_Click);
			//
			// dgDirtyObjects
			//
			this.dgDirtyObjects.AccessibleDescription = resources.GetString("dgDirtyObjects.AccessibleDescription");
			this.dgDirtyObjects.AccessibleName = resources.GetString("dgDirtyObjects.AccessibleName");
			this.dgDirtyObjects.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("dgDirtyObjects.Anchor")));
			this.dgDirtyObjects.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("dgDirtyObjects.BackgroundImage")));
			this.dgDirtyObjects.CaptionFont = ((System.Drawing.Font)(resources.GetObject("dgDirtyObjects.CaptionFont")));
			this.dgDirtyObjects.CaptionText = resources.GetString("dgDirtyObjects.CaptionText");
			this.dgDirtyObjects.DataMember = "";
			this.dgDirtyObjects.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("dgDirtyObjects.Dock")));
			this.EcoAutoForms.SetEcoAutoForm(this.dgDirtyObjects, true);
			this.EcoDragDrop.SetEcoDragSource(this.dgDirtyObjects, true);
			this.dgDirtyObjects.Enabled = ((bool)(resources.GetObject("dgDirtyObjects.Enabled")));
			this.dgDirtyObjects.Font = ((System.Drawing.Font)(resources.GetObject("dgDirtyObjects.Font")));
			this.dgDirtyObjects.HeaderForeColor = System.Drawing.SystemColors.ControlText;
			this.dgDirtyObjects.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("dgDirtyObjects.ImeMode")));
			this.dgDirtyObjects.Location = ((System.Drawing.Point)(resources.GetObject("dgDirtyObjects.Location")));
			this.dgDirtyObjects.Name = "dgDirtyObjects";
			this.dgDirtyObjects.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("dgDirtyObjects.RightToLeft")));
			this.dgDirtyObjects.Size = ((System.Drawing.Size)(resources.GetObject("dgDirtyObjects.Size")));
			this.dgDirtyObjects.TabIndex = ((int)(resources.GetObject("dgDirtyObjects.TabIndex")));
			this.dgDirtyObjects.Visible = ((bool)(resources.GetObject("dgDirtyObjects.Visible")));
			//
			// EcoAutoForms
			//
			this.EcoAutoForms.ContainerReusage = Borland.Eco.AutoContainers.ContainerReusage.ReuseForElement;
			//
			// EcoGlobalActions
			//
			this.EcoGlobalActions.RootHandle = this.rhRoot;
			//
			// mainMenu1
			//
			this.mainMenu1.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("mainMenu1.RightToLeft")));
			//
			// DirtyObjectsDebuggerPanel
			//
			this.AccessibleDescription = resources.GetString("$this.AccessibleDescription");
			this.AccessibleName = resources.GetString("$this.AccessibleName");
			this.AutoScaleBaseSize = ((System.Drawing.Size)(resources.GetObject("$this.AutoScaleBaseSize")));
			this.AutoScroll = ((bool)(resources.GetObject("$this.AutoScroll")));
			this.AutoScrollMargin = ((System.Drawing.Size)(resources.GetObject("$this.AutoScrollMargin")));
			this.AutoScrollMinSize = ((System.Drawing.Size)(resources.GetObject("$this.AutoScrollMinSize")));
			this.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("$this.BackgroundImage")));
			this.ClientSize = ((System.Drawing.Size)(resources.GetObject("$this.ClientSize")));
			this.Controls.Add(this.panel1);
			this.Enabled = ((bool)(resources.GetObject("$this.Enabled")));
			this.Font = ((System.Drawing.Font)(resources.GetObject("$this.Font")));
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("$this.ImeMode")));
			this.Location = ((System.Drawing.Point)(resources.GetObject("$this.Location")));
			this.MaximumSize = ((System.Drawing.Size)(resources.GetObject("$this.MaximumSize")));
			this.Menu = this.mainMenu1;
			this.MinimumSize = ((System.Drawing.Size)(resources.GetObject("$this.MinimumSize")));
			this.Name = "DirtyObjectsDebuggerPanel";
			this.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("$this.RightToLeft")));
			this.StartPosition = ((System.Windows.Forms.FormStartPosition)(resources.GetObject("$this.StartPosition")));
			this.Text = resources.GetString("$this.Text");
			this.panel1.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.dgDirtyObjects)).EndInit();
			this.ResumeLayout(false);
		}
		#endregion

		public Borland.Eco.Handles.EcoSpace EcoSpace
		{
			get { return (Borland.Eco.Handles.EcoSpace)rhRoot.EcoSpace; }
			set { rhRoot.EcoSpace = value; }
		}

		private static void SetupDefaultColumns(ElementHandle handle)
		{
			if (handle.Columns.Count == 0)
			{
				OclColumn col1 = new OclColumn();
				col1.Expression = "self.oclType.asString"; // do not localize
				col1.Name = "Type"; // do not localize
				OclColumn col2 = new OclColumn();
				col2.Expression = "self.asString"; // do not localize
				col2.Name = "AsString"; // do not localize
				handle.Columns.AddRange(new AbstractColumn[] {col1, col2});
			}
		}

		Panel IEcoSpaceDebuggerPanel.Panel { get { return panel1; } }
		string IEcoSpaceDebuggerPanel.Caption { get { return FormsStringRes.sDirtyObjects; } }
		MainMenu IEcoSpaceDebuggerPanel.MainMenu { get { return mainMenu1; } }
		void IEcoSpaceDebuggerPanel.Init(EcoSpace es)
		{
			this.EcoSpace = es;

			IClassifier rootClass = TypeSystemService.TypeSystem.AllClasses[0];

			selectedObjects = VariableFactoryService.CreateUntypedObjectList(false);

			rhSelectedObjects.EcoSpace = es;
//			rhSelectedObjects.EcoSpaceType = es.GetType();
			rhSelectedObjects.StaticValueTypeName= rootClass.CollectionType.Name;

			rhSelectedObjects.SetElement(selectedObjects);
			rhRoot.StaticValueTypeName= rootClass.CollectionType.Name;

			SetupDefaultColumns(rhSelectedObjects);
			SetupDefaultColumns(rhRoot);

			dgDirtyObjects.DataSource = rhRoot;
			lbSelectedObjects.DataSource = rhSelectedObjects;
			lbSelectedObjects.DisplayMember = "AsString";

			UpdateDirtyList();
			dirtyListSubscriber = new DirtyListSubscriber(this);
			DirtyListService.Subscribe(dirtyListSubscriber);
		}

		IObjectList selectedObjects;

		private DirtyListSubscriber dirtyListSubscriber;

		private void UpdateDirtyList()
		{
			rhRoot.SetElement( DirtyListService.AllDirtyObjects());
		}

		internal void Receive()
		{
			UpdateDirtyList();
		}

		private void btnUpdate_Click(object sender, System.EventArgs e)
		{
			PersistenceService.UpdateDatabaseWithList(selectedObjects);
			selectedObjects.Clear();
		}

		private void btnSelect_Click(object sender, System.EventArgs e)
		{
			IObject obj = CurrencyManagerHandle.CurrentElement(rhRoot, dgDirtyObjects) as IObject;
			if (obj != null)
				selectedObjects.Add(obj);
		}

		private void btnUnselect_Click(object sender, System.EventArgs e)
		{
			IObject obj = CurrencyManagerHandle.CurrentElement(rhSelectedObjects, lbSelectedObjects) as IObject;
			if (obj != null)
				selectedObjects.Remove(obj);
		}

		private void btnEnclosure_Click(object sender, System.EventArgs e)
		{
			PersistenceService.EnsureEnclosure(selectedObjects);
		}

		private void btnPurge_Click(object sender, System.EventArgs e)
		{
			IObjectList dirtyObjects = DirtyListService.AllDirtyObjects();
			for (int i=0; i<selectedObjects.Count; i++)
			{
				if (!dirtyObjects.Contains(selectedObjects[i]))
					selectedObjects.RemoveAt(i);
			}
		}

		private void button1_Click(object sender, System.EventArgs e)
		{
			foreach (IObject o in DirtyListService.AllDirtyObjects())
			selectedObjects.Add(o);
		}

		private void btnUnselectAll_Click(object sender, System.EventArgs e)
		{
			selectedObjects.Clear();
		}

		private class DirtyListSubscriber: SubscriberAdapterBase
		{
			///<exception cref="ArgumentNullException">Thrown if <paramref name="actualSubscriber"/> is null.</exception>
			protected override void DoReceive(object sender, EventArgs e, object actualSubscriber)
			{
				if (actualSubscriber == null)
					throw new ArgumentNullException("actualSubscriber"); // do not localize
				(actualSubscriber as DirtyObjectsDebuggerPanel).Receive();
			}
			public DirtyListSubscriber(object subscriber): base(subscriber)
			{
			}
		}
	}
}
